; ZX Nano Rally 256bytes VERSION 1.0 (l) Nik@losw.ru 2022 for LoveByte'22
; comile with RASM

	BUILD ZX
	ORG	0x7D00

$scraddr	equ	0x5800	; screen attribute area
$scrwidth	equ	32	; screen = 32 columns width
$scrheight	equ	24	; and 24 rows height

$mapaddr	equ	0x7F00	; buffer for drawing a road
$mapheight	equ	27	; 3 row longer then screen

$roadwidth	equ	16	; road width
$init_car_cnt	equ	64	; first emeny car will be placed on 64s road line
$init_road_pos	equ	8	; first road part will be placed in center of 
$init_road_targ	equ	8	; screen

$init_delay	equ	4500	; initinal delay counter
$init_car_y	equ	5	; player's car placed 5 lines up from bottom of scr
$init_car_x	equ	15	; player's car placed in ceneter of scr

$keyport	equ	0xFE	; zx in/out port
$keys1to5	equ	0xF7	; address for keys from 1 to 5
$keys0to6	equ	0xEF	; address for keys from 0 to 6
$keysBtoSp	equ	0x7F	; address for key from B to Space
$key5		equ	00010000b	; key 5 = left for cursor joystick
$key8		equ	00000100b	; key 8 = right for cursor joystick

$grass		equ	00100100b	; grass color around road
$sand		equ	00110110b	; road color
$body		equ	00010010b	; player's car color
$glass		equ	00101101b	; cars glasses color

new:	; new game routine
	exx			; most of variables stored in alt registers
	ld	bc,$init_road_pos*256+$init_car_cnt ;b=road position c=emeny delay
	ld	de,$mapheight*256+$init_road_targ ;d=road cnt e=road target
	ld	hl,$init_delay ; initial speed
	exx

	ld	b,$mapheight	; draw first 27 road lines in buffer
init:	push	bc
	call road_prn:
	pop	bc
	djnz init:

	ld	hl,$scraddr+$scrwidth*($scrheight-$init_car_y)+$init_car_x ; hl=car address
main:	; main game cycle routine
	ld	a,$keys0to6	; check right key and inc car address if pressed
	in	a,($keyport)	; there is no boundary checks becouse road always 
	and	$key8		; framed with grass
	jr nz,next1:
	inc	hl
next1:	ld	a,$keys1to5	; check left key and dec car address if pressed
	in	a,($keyport)
	and	$key5
	jr nz,next2:
	dec	hl

next2:	push	hl
	call road_prn:		; draw new road line
	add	a		; form a beeper bit from last bit of counter that
	add	a		; was returned from road_prn routine
	add	a
	add	a
	or	00000111b
	out	($keyport),a	; and beep sound

	exx			; decrement speed delay counter every road line
	dec	hl
	ld	a,h
	or	l
	jr nz,next3:
	inc	h
next3:	push	hl
	exx

	pop	bc		; delay 26*(delay counter) ticks 
delay:	dec	bc
	ld	a,b
	or	c
	jr nz,delay:
	halt			; and wait for nearest screeen refresh

	ld	de,$scraddr	; copy last 24 lines of buffer to screen
	ld	hl,$mapaddr+$scrwidth*($mapheight-$scrheight)
	ld	bc,$scrwidth*$scrheight
	ldir

	pop	hl
	ld	b,$body
	push	hl
	call car_prn:		; draw player's car on screen
	pop	hl
	xor	$sand		; check collision while drawing car

	jr z,main:		; if not - go to next game cycle
;jr main:	; cheat mode :)

	ld	b,d		; if yes - beep sound and set border to black
boom:	ld	a,b
	dec	a		; b=x..1 and a=x-1..0
	out	($keyport),a
	add	hl,de
	add	hl,de
	djnz boom:
pause:	ld	a,$keysBtoSp	; then wait until space key pressed for new game
	in	a,($keyport)
	rra			; Space is the first key in BtoSp keyline
	jr c,pause:
	jr new:


road_prn:		; routine for draw new road line
module	road_prn	; in(no) out(no) modify(all)

	ld	de,$mapaddr+$scrwidth*$mapheight-1	; shift buffer one line down
	ld	hl,$mapaddr+$scrwidth*($mapheight-1)-1
	ld	bc,$scrwidth*($mapheight-1)
	lddr

	exx
	ld	a,d
	or	a	; if road counter!=0
	jr nz,flat:	; then continue draw straight road
	ld	a,e	; if road counter=0 then draw next line shifted to left
	cp	b	; or right depend on current position and target value
	jr nz,move:	; if road reached target position then form next road part
	call random:
	ld	d,a	; new lenght of road straight part
	call random:
	ld	e,a	; new target position for next road turn
	jr cont:
move:	jr c,left:	; shift new roadline to left or right depend of target value
rigth:	inc	b
	inc	b
left:	dec	b
	inc	d
flat:	dec	d	; decrease straight road counter if drawing straight part
cont:	dec	c	; decrease next emeny car counter
	push	bc	; and store road position and emeny counter for later usage
	jr nz,next1:
	call random:	; if emeny car counter=0 take a new value
	rla		; but random return values in 1..15 range
	rla		; and emeny car counter must be much greater so
	rla		; multiple random by 8
	ld	c,a
next1:	exx

	pop	bc		; b=road position c=emeny car counter
	ld	a,$scrwidth	; using reg A for calculate right grass size
	ld	hl,$mapaddr
loop1:	ld	(hl),$grass	; drawing left grass until road position
	inc	hl
	dec	a
	djnz loop1:
	ld	e,l		; store road start address for drawing emeny car
	ld	b,$roadwidth	; drawing road
loop2:	ld	(hl),$sand
	inc	hl
	dec	a
	djnz loop2:
	ld	b,a		; (right grass)=(scr width)-(road width)-(road pos)
loop3:	ld	(hl),$grass	; drawing right grass
	inc	hl
	djnz loop3:

	ld	a,c	; if emeny car counetr!=0 then return
	or	a
	ret nz

	call random:	; else draw emeny car
	dec	a	; car position on the road must be in 0..road width-2 range
	jr z,next2:	; so convert 1..15 random to 0..13 road position
	dec	a
next2:	add	e
	ld	l,a
	call random:	; pick color for emeny car.
	and 00000111b	; there is a shorter version of picking color with less
	jr nz,next3:	; clolors: just random and xor 3
	inc a
next3:	xor 00000110b
	ld	b,a	; ink color must be same as paper color
	rla
	rla
	rla
	or	b
	ld	b,a
;;	call car_prn:	; for codesize reduction car_prn routine just linked below
;;	ret		;
module	off

car_prn:			; draw car on screen or in buffer
module	car_prn			; in(hl=addr for draw,b=color) out(a!=$sand -crash)
				; modified(a, de, hl)
	ld	de,$scrwidth-1	; de=addr shift and d=$tyre
	ld	a,(hl)
	call tail:		; draw front line
	add	hl,de
	ld	(hl),$glass	; draw middle
	add	hl,de
tail:	and	(hl)		; draw back line
	ld	(hl),d
	inc	hl
	ld	(hl),b
	inc	hl
	and	(hl)
	ld	(hl),d
	ret
module	off

random:
module	random	; random number in range 1..15

        push	hl
        push	de
_seed	equ $+1
	ld	hl,0000
        ld	a,r
        ld	d,a
        ld	e,(hl)
        add	hl,de
        add	a,l
        xor	h
        ld	(_seed),hl
	pop	de
        pop	hl
	and	00001111b
	ret nz
	inc	a
	ret
module off


